FUNCTION GetTime
#pragma Line,0
(* Get the current time as a string *)
currentTime := TIME_TO_STRING(RTEngine.RelativeTime);

(*                   *)
(* ===> SECONDS <=== *)
(*                   *)

(* Find start and end position *)
posStart := FIND(currentTime, "m") + 1;
posEnd   := FIND(currentTime, "s");

IF (posEnd - posStart) > 2 THEN
    TimeSeconds := 0;
ELSE
    (* Get the portion of the string *)
    timePortion := MID(currentTime, posEnd - posStart, posStart);

    (* Convert portion to integer *)
    TimeSeconds := STRING_TO_INT(timePortion);
END_IF;

(*                        *)
(* ===> MILLISECONDS <=== *)
(*                        *)

(* Find start and end position *)
posStart := FIND(currentTime, "s") + 1;
posEnd   := FIND(currentTime, "ms");

(* Get the portion of the string *)
timePortion := MID(currentTime, posEnd - posStart, posStart);

(* Convert portion to integer *)
TimeMilliseconds := STRING_TO_INT(timePortion);


END_FUNCTION
